<?php
require_once __DIR__ . '/../app/Core/Config.php';
require_once __DIR__ . '/../app/Core/Database.php';
require_once __DIR__ . '/../app/Core/App.php';

// Autoloader for Controllers, Models, Core
spl_autoload_register(function ($class) {
    $paths = [__DIR__ . '/../app/Controllers/', __DIR__ . '/../app/Models/', __DIR__ . '/../app/Core/'];
    foreach ($paths as $p) {
        $file = $p . $class . '.php';
        if (file_exists($file)) require_once $file;
    }
});

$app = new App();
$app->run();
