<div class="row">
  <div class="col-md-6">
    <?php if(!empty($product['image'])): ?>
      <img src="<?php echo $product['image'];?>" class="img-fluid rounded">
    <?php endif;?>
  </div>
  <div class="col-md-6">
    <h3><?php echo htmlspecialchars($product['name']);?></h3>
    <p class="text-muted"><?php echo nl2br(htmlspecialchars($product['description']));?></p>
    <h4>₹ <span id="price"><?php echo number_format($product['price'],2);?></span></h4>
    <?php if(!empty($product['variants'])): ?>
      <label for="variant">Choose variant</label>
      <select id="variant" class="form-select mb-2">
        <option value="0">-- Default --</option>
        <?php foreach($product['variants'] as $v): ?>
          <option value="<?php echo $v['id'];?>" data-price="<?php echo $v['price'];?>"><?php echo htmlspecialchars($v['name']);?> (+₹<?php echo number_format($v['price'],2);?>)</option>
        <?php endforeach;?>
      </select>
    <?php endif;?>
    <div class="d-flex mb-3">
      <input id="qty" type="number" class="form-control me-2" value="1" min="1" style="max-width:120px;">
      <button id="add-cart" class="btn btn-success">Add to cart</button>
    </div>
    <div id="msg"></div>
  </div>
</div>

<script>
$('#variant').on('change', function(){
  var price = $(this).find(':selected').data('price') || <?php echo $product['price'];?>;
  $('#price').text(parseFloat(price).toFixed(2));
});
$('#add-cart').on('click', function(){
  $.post('/cart/add', {product_id: <?php echo $product['id'];?>, variant_id: $('#variant').val(), qty: $('#qty').val()}, function(res){
    if(res.status=='ok'){ $('#msg').html('<div class="alert alert-success">Added to cart</div>'); $('#cart-count').text(res.cart_count); }
    else $('#msg').html('<div class="alert alert-danger">Error</div>');
  }, 'json');
});
</script>
